/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http.apache;

import br.com.caelum.restfulie.Response;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.RestfulieException;
import br.com.caelum.restfulie.http.Headers;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.http.apache.ApacheHeaders;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheResponse
implements Response {
    private final HttpResponse response;
    private final RestClient client;
    private HttpEntity entity;
    private final Request details;

    public ApacheResponse(HttpResponse response, RestClient client, Request details) {
        this.response = response;
        this.client = client;
        this.details = details;
        this.entity = response.getEntity();
    }

    @Override
    public int getCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getContent() {
        if (this.entity == null) {
            return "";
        }
        try {
            long len = this.entity.getContentLength();
            if (len < 0xA00000L) {
                return EntityUtils.toString((HttpEntity)this.entity);
            }
            return "";
        }
        catch (IOException ex) {
            throw new RestfulieException("Unable to parse response content", ex);
        }
    }

    @Override
    public List<String> getHeader(String key) {
        return this.getHeaders().get(key);
    }

    @Override
    public <T> T getResource() {
        String contentType = this.getType();
        String content = this.getContent();
        return this.client.getMediaTypes().forContentType(contentType).unmarshal(content, this.client);
    }

    @Override
    public String getType() {
        return this.getHeaders().getMain("Content-Type");
    }

    @Override
    public Headers getHeaders() {
        return new ApacheHeaders(this.response, this.client);
    }

    public void discard() throws IOException {
        this.response.getEntity().consumeContent();
    }

    @Override
    public URI getLocation() {
        try {
            String location = this.getHeaders().getFirst("Location");
            if (location == null || location.equals("")) {
                return this.getRequest().getURI();
            }
            return new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RestfulieException("Invalid URI received as a response", e);
        }
    }

    @Override
    public Request getRequest() {
        return this.details;
    }

    @Override
    public String getStatusLine() {
        return this.response.getStatusLine().getReasonPhrase();
    }
}

