/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http.apache;

import br.com.caelum.restfulie.Link;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.http.DefaultHeader;
import br.com.caelum.restfulie.http.DefaultRelation;
import br.com.caelum.restfulie.http.Header;
import br.com.caelum.restfulie.http.Headers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheHeaders
implements Headers {
    private final HttpResponse response;
    private List<Link> links;
    private final RestClient client;

    public ApacheHeaders(HttpResponse response, RestClient client) {
        this.response = response;
        this.client = client;
        this.links = new ArrayList<Link>();
    }

    @Override
    public String getMain(String key) {
        return this.getFirst(key).split(";")[0];
    }

    @Override
    public List<String> get(String key) {
        org.apache.http.Header[] values = this.response.getHeaders(key);
        ArrayList<String> list = new ArrayList<String>();
        for (org.apache.http.Header h : values) {
            list.add(h.getValue());
        }
        return list;
    }

    @Override
    public String getFirst(String key) {
        org.apache.http.Header[] headers = this.response.getHeaders(key);
        return headers != null && headers.length > 0 ? this.get(key).get(0) : "";
    }

    @Override
    public List<Link> getLinks() {
        if (this.links.isEmpty()) {
            for (String links : this.get("link")) {
                for (String link : links.split(",")) {
                    String[] split = link.split(";");
                    String href = split[0].trim().substring(1, split[0].trim().length() - 1);
                    String rel = split[1].trim().substring(5, split[1].trim().length() - 1);
                    this.links.add(new DefaultRelation(rel, href, "", this.client));
                }
            }
        }
        return this.links;
    }

    @Override
    public Link getLink(String rel) {
        this.getLinks();
        for (Link link : this.links) {
            if (!link.getRel().equals(rel)) continue;
            return link;
        }
        return null;
    }

    @Override
    public Iterator<Header> iterator() {
        ArrayList<DefaultHeader> headers = new ArrayList<DefaultHeader>();
        for (org.apache.http.Header apacheHeader : this.response.getAllHeaders()) {
            DefaultHeader h = new DefaultHeader(apacheHeader.getName(), apacheHeader.getValue());
            headers.add(h);
        }
        return headers.iterator();
    }
}

