/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http.apache;

import br.com.caelum.restfulie.Response;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.RestfulieException;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.http.apache.ApacheResponse;
import br.com.caelum.restfulie.mediatype.MediaType;
import br.com.caelum.restfulie.request.RequestDispatcher;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheDispatcher
implements RequestDispatcher {
    private final HttpClient http = new DefaultHttpClient();
    private final RestClient client;
    private final HttpContext context;
    private ApacheResponse lastExecuted;

    public ApacheDispatcher(RestClient client) {
        this.client = client;
        this.context = new BasicHttpContext();
        this.context.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
    }

    @Override
    public Response process(Request details, String method, URI uri, Object payload) {
        if (payload == null) {
            return this.access(details, method, uri);
        }
        Map<String, String> headers = details.getHeaders();
        if (!headers.containsKey("Content-type")) {
            throw new RestfulieException("You should set a content type prior to sending some payload.");
        }
        StringWriter writer = new StringWriter();
        String type = headers.get("Content-type");
        try {
            this.handlerFor(type).marshal(payload, writer, this.client);
            writer.flush();
            HttpEntityEnclosingRequestBase verb = (HttpEntityEnclosingRequestBase)this.verbFor(method, uri);
            this.add((HttpRequest)verb, headers);
            String string = writer.getBuffer().toString();
            verb.setEntity((HttpEntity)new StringEntity(string));
            return this.execute(details, (HttpUriRequest)verb);
        }
        catch (IOException e) {
            throw new RestfulieException("Unable to marshal entity.", e);
        }
    }

    private HttpContext getContext() {
        return this.context;
    }

    private MediaType handlerFor(String type) {
        return this.client.getMediaTypes().forContentType(type);
    }

    private void add(HttpRequest method, Map<String, String> headers) {
        for (String header : headers.keySet()) {
            method.addHeader(header, headers.get(header));
        }
    }

    private Response access(Request request, String method, URI uri) {
        HttpUriRequest verb = this.verbFor(method, uri);
        this.add((HttpRequest)verb, request.getHeaders());
        return this.execute(request, verb);
    }

    private HttpUriRequest verbFor(String method, URI uri) {
        if ((method = method.toUpperCase()).equals("GET")) {
            return new HttpGet(uri);
        }
        if (method.equals("PUT")) {
            return new HttpPut(uri);
        }
        if (method.equals("POST")) {
            return new HttpPost(uri);
        }
        if (method.equals("DELETE")) {
            return new HttpDelete(uri);
        }
        if (method.equals("TRACE")) {
            return new HttpTrace(uri);
        }
        if (method.equals("OPTIONS")) {
            return new HttpOptions(uri);
        }
        if (method.equals("HEAD")) {
            return new HttpHead(uri);
        }
        throw new RestfulieException("You can not " + method + " to " + uri + ", there is no such verb in the apache http API.");
    }

    private ApacheResponse execute(Request details, HttpUriRequest method) {
        try {
            if (this.lastExecuted != null) {
                this.lastExecuted.discard();
            }
            HttpResponse response = this.http.execute(method, this.getContext());
            return this.responseFor(response, details);
        }
        catch (ClientProtocolException e) {
            throw new RestfulieException("Unable to execute " + method.getURI(), e);
        }
        catch (IOException e) {
            throw new RestfulieException("Unable to execute " + method.getURI(), e);
        }
    }

    private ApacheResponse responseFor(HttpResponse response, Request details) throws IOException {
        this.lastExecuted = new ApacheResponse(response, this.client, details);
        return this.lastExecuted;
    }
}

