/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http;

import br.com.caelum.restfulie.http.ContentProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class HttpURLConnectionContentProcessor
implements ContentProcessor {
    private final HttpURLConnection connection;
    private String cachedContent = null;

    public HttpURLConnectionContentProcessor(HttpURLConnection connection) {
        this.connection = connection;
    }

    public String read() throws IOException {
        String partial;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        InputStream stream = (InputStream)this.connection.getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder content = new StringBuilder();
        while ((partial = reader.readLine()) != null) {
            if (content.length() != 0) {
                content.append("\n");
            }
            content.append(partial);
        }
        this.cachedContent = content.toString();
        return this.cachedContent;
    }
}

