/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http;

import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.RestfulieException;
import br.com.caelum.restfulie.http.DefaultHttpRequest;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.http.apache.ApacheDispatcher;
import br.com.caelum.restfulie.mediatype.FormEncoded;
import br.com.caelum.restfulie.mediatype.JsonMediaType;
import br.com.caelum.restfulie.mediatype.MediaTypes;
import br.com.caelum.restfulie.mediatype.XmlMediaType;
import br.com.caelum.restfulie.request.RequestDispatcher;
import java.net.URI;
import java.net.URISyntaxException;
import org.jvnet.inflector.Pluralizer;
import org.jvnet.inflector.lang.en.NounPluralizer;

public class DefaultRestClient
implements RestClient {
    private final MediaTypes types = new MediaTypes();
    private RequestDispatcher dispatcher = new ApacheDispatcher(this);
    private Pluralizer inflector = new NounPluralizer();
    private URI lastURI = null;

    public DefaultRestClient() {
        this.types.register(new XmlMediaType());
        this.types.register(new JsonMediaType());
        this.types.register(new FormEncoded());
    }

    public DefaultRestClient use(RequestDispatcher executor) {
        this.dispatcher = executor;
        return this;
    }

    public RequestDispatcher getProvider() {
        return this.dispatcher;
    }

    public MediaTypes getMediaTypes() {
        return this.types;
    }

    public Request at(URI uri) {
        this.lastURI = uri;
        return this.createRequestFor(uri);
    }

    protected Request createRequestFor(URI uri) {
        return new DefaultHttpRequest(uri, this);
    }

    public Request at(String uri) {
        try {
            return this.at(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RestfulieException("Unable to build an URI for this request.", e);
        }
    }

    public URI lastURI() {
        return this.lastURI;
    }

    public Pluralizer inflectionRules() {
        return this.inflector;
    }

    public RestClient withInflector(Pluralizer inflector) {
        this.inflector = inflector;
        return this;
    }
}

