/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http;

import br.com.caelum.restfulie.Response;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.feature.FollowRedirects;
import br.com.caelum.restfulie.feature.RequestFeature;
import br.com.caelum.restfulie.feature.ResponseFeature;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.request.RequestStack;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpRequest
implements Request {
    private String verb = "GET";
    private final Map<String, String> headers = new HashMap<String, String>();
    private final URI uri;
    private final RestClient client;
    private RequestStack stack;

    public DefaultHttpRequest(URI uri, RestClient client) {
        this.uri = uri;
        this.client = client;
        this.stack = new RequestStack(client);
    }

    private Response sendPayload(Object payload, String verb) {
        RequestStack stack = this.createStack();
        return stack.process(this, verb, this.uri, payload);
    }

    @Override
    public Request with(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Request using(String verb) {
        this.verb = verb;
        return this;
    }

    @Override
    public Request accept(String type) {
        return this.with("Accept", type);
    }

    @Override
    public Response get() {
        return this.retrieve("GET");
    }

    private Response retrieve(String verb) {
        return this.using(verb).access();
    }

    @Override
    public Request as(String contentType) {
        return this.with("Content-type", contentType);
    }

    @Override
    public Response delete() {
        return this.retrieve("DELETE");
    }

    @Override
    public Response head() {
        return this.retrieve("HEAD");
    }

    @Override
    public Response options() {
        return this.retrieve("OPTIONS");
    }

    @Override
    public <T> Response patch(T object) {
        return this.sendPayload(object, "PATCH");
    }

    @Override
    public <T> Response post(T object) {
        return this.sendPayload(object, "POST");
    }

    @Override
    public <T> Response put(T object) {
        return this.sendPayload(object, "PUT");
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Request addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    @Override
    public Response access() {
        RequestStack stack = this.createStack();
        return stack.process(this, this.verb, this.uri, null);
    }

    protected RequestStack createStack() {
        this.stack.with(new FollowRedirects(this.client));
        return this.stack;
    }

    @Override
    public Request handling(String type) {
        return this.as(type).accept(type);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request with(RequestFeature feature) {
        this.stack.with(feature);
        return this;
    }

    @Override
    public Request with(ResponseFeature feature) {
        return this;
    }
}

