/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.feature;

import br.com.caelum.restfulie.Response;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.feature.ResponseFeature;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.request.ResponseChain;
import java.net.URI;

public class FollowRedirects
implements ResponseFeature {
    private final RestClient client;

    public FollowRedirects(RestClient client) {
        this.client = client;
    }

    public Response process(ResponseChain chain, Response response) {
        if (this.shouldRedirect(response)) {
            String uri = response.getHeader("Location").get(0);
            Request request = response.getRequest();
            if (uri.charAt(0) == '/') {
                URI target = request.getURI().resolve(uri);
                return this.client.at(target).addHeaders(request.getHeaders()).get();
            }
            return this.client.at(uri).addHeaders(request.getHeaders()).get();
        }
        return response;
    }

    protected boolean shouldRedirect(Response response) {
        return response.getCode() / 100 == 3 || response.getCode() == 201;
    }
}

