/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.reflection;

import br.com.caelum.iogi.Instantiator;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.vidageek.mirror.dsl.Matcher;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewObject {
    private final Instantiator<?> propertiesInstantiator;
    private final Parameters parameters;
    private final Object object;

    public static NewObject nullNewObject() {
        return new NewObject(null, null, (Object)null){

            public Object value() {
                return null;
            }

            public Object valueWithPropertiesSet() {
                return null;
            }
        };
    }

    public NewObject(Instantiator<?> propertiesInstantiator, Parameters parameters, Object newObjectValue) {
        this.propertiesInstantiator = propertiesInstantiator;
        this.parameters = parameters;
        this.object = newObjectValue;
    }

    public Object valueWithPropertiesSet() {
        this.populateProperties();
        return this.value();
    }

    public Object value() {
        return this.object;
    }

    private void populateProperties() {
        for (Setter setter : Setter.settersIn(this.object)) {
            this.setProperty(setter);
        }
    }

    private void setProperty(Setter setter) {
        if (this.parameters.hasRelatedTo(setter.asTarget())) {
            Object propertyValue = this.propertiesInstantiator.instantiate(setter.asTarget(), this.parameters);
            setter.set(propertyValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScalaSetter
    extends Setter {
        public ScalaSetter(Method setter, Object object) {
            super(setter, object);
        }

        @Override
        protected String propertyName() {
            return this.setter.getName().replace("_$eq", "");
        }

        static List<Method> settersOf(Object object) {
            return new Mirror().on(object.getClass()).reflectAll().methodsMatching((net.vidageek.mirror.list.dsl.Matcher)new Matcher<Method>(){

                public boolean accepts(Method method) {
                    return method.getName().endsWith("_$eq");
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSetter
    extends Setter {
        public JavaSetter(Method setter, Object object) {
            super(setter, object);
        }

        @Override
        protected String propertyName() {
            String capitalizedPropertyName = this.setter.getName().substring(3);
            String propertyName = capitalizedPropertyName.substring(0, 1).toLowerCase() + capitalizedPropertyName.substring(1);
            return propertyName;
        }

        static List<Method> settersOf(Object object) {
            return new Mirror().on(object.getClass()).reflectAll().methodsMatching((net.vidageek.mirror.list.dsl.Matcher)new Matcher<Method>(){

                public boolean accepts(Method method) {
                    return method.getName().startsWith("set");
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Setter {
        protected final Method setter;
        private final Object object;

        private static Collection<Setter> settersIn(Object object) {
            ArrayList<Setter> setters = new ArrayList<Setter>();
            for (Method setterMethod : JavaSetter.settersOf(object)) {
                setters.add(new JavaSetter(setterMethod, object));
            }
            for (Method setterMethod : ScalaSetter.settersOf(object)) {
                setters.add(new ScalaSetter(setterMethod, object));
            }
            return Collections.unmodifiableList(setters);
        }

        public Setter(Method setter, Object object) {
            this.setter = setter;
            this.object = object;
        }

        public void set(Object argument) {
            new Mirror().on(this.object).invoke().method(this.setter).withArgs(new Object[]{argument});
        }

        private Target<Object> asTarget() {
            return new Target<Object>(this.type(), this.propertyName());
        }

        protected abstract String propertyName();

        private Type type() {
            return this.setter.getGenericParameterTypes()[0];
        }

        public String toString() {
            return "Setter(" + this.propertyName() + ")";
        }
    }
}

