/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.reflection;

import br.com.caelum.iogi.DependenciesInjector;
import br.com.caelum.iogi.Instantiator;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.ClassConstructor;
import br.com.caelum.iogi.reflection.NewObject;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.util.Ints;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructors {
    public static final Ordering<ClassConstructor> orderConstructorsBySize = new Ordering<ClassConstructor>(){

        public int compare(ClassConstructor first, ClassConstructor second) {
            return Ints.compare(first.size(), second.size());
        }
    };
    private final Collection<ClassConstructor> classConstructors;
    private final DependenciesInjector dependenciesInjector;

    public Constructors(Collection<ClassConstructor> constructors, DependenciesInjector dependenciesInjector) {
        this.classConstructors = constructors;
        this.dependenciesInjector = dependenciesInjector;
    }

    public FilledConstructors compatibleWith(Parameters relevantParameters) {
        LinkedList<ClassConstructor> compatible = new LinkedList<ClassConstructor>();
        for (ClassConstructor classConstructor : this.classConstructors) {
            if (!classConstructor.canInstantiateOrInject(relevantParameters, this.dependenciesInjector)) continue;
            compatible.add(classConstructor);
        }
        return new FilledConstructors(compatible, relevantParameters, this.dependenciesInjector);
    }

    public int size() {
        return this.classConstructors.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilledConstructor {
        private final ClassConstructor constructor;
        private final Parameters parameters;
        private final DependenciesInjector dependenciesInjector;

        private static FilledConstructor nullFilledConstructor() {
            return new FilledConstructor(null, null, null){

                @Override
                public NewObject instantiate(Instantiator<Object> argumentInstantiator) {
                    return NewObject.nullNewObject();
                }
            };
        }

        public FilledConstructor(ClassConstructor constructor, Parameters parameters, DependenciesInjector dependenciesInjector) {
            this.constructor = constructor;
            this.parameters = parameters;
            this.dependenciesInjector = dependenciesInjector;
        }

        public NewObject instantiate(Instantiator<Object> argumentInstantiator) {
            Object newObjectValue = this.constructor.construct(this.argumentValues(argumentInstantiator));
            return new NewObject(argumentInstantiator, this.parameters, newObjectValue);
        }

        private List<Object> argumentValues(Instantiator<Object> argumentInstantiator) {
            ArrayList argumentValues = Lists.newArrayList();
            for (Target<?> target : this.constructor.argumentTargets()) {
                argumentValues.add(this.argumentValue(argumentInstantiator, target));
            }
            return argumentValues;
        }

        private Object argumentValue(Instantiator<Object> argumentInstantiator, Target<?> target) {
            if (this.needsDependency(target)) {
                return this.dependenciesInjector.provide(target);
            }
            return argumentInstantiator.instantiate(target, this.parameters);
        }

        private boolean needsDependency(Target<?> target) {
            return this.targetsNeedingADependency().contains(target);
        }

        private Collection<Target<?>> targetsNeedingADependency() {
            return this.constructor.notFulfilledBy(this.parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilledConstructors {
        private final Collection<ClassConstructor> classConstructors;
        private final Parameters parameters;
        private final DependenciesInjector dependenciesInjector;

        public FilledConstructors(Collection<ClassConstructor> classConstructors, Parameters parameters, DependenciesInjector dependenciesInjector) {
            this.classConstructors = classConstructors;
            this.parameters = parameters;
            this.dependenciesInjector = dependenciesInjector;
        }

        public FilledConstructor largest() {
            if (this.classConstructors.isEmpty()) {
                return FilledConstructor.nullFilledConstructor();
            }
            ClassConstructor largestConstructor = (ClassConstructor)orderConstructorsBySize.max(this.classConstructors);
            return new FilledConstructor(largestConstructor, this.parameters, this.dependenciesInjector);
        }
    }
}

