/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.parameters;

import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.reflection.ClassConstructor;
import br.com.caelum.iogi.reflection.Target;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    private final ListMultimap<String, Parameter> parametersByFirstNameComponent;

    public Parameters(Parameter ... parameters) {
        this(Arrays.asList(parameters));
    }

    public Parameters(List<Parameter> parametersList) {
        this.parametersByFirstNameComponent = this.groupByFirstNameComponent(parametersList);
    }

    private ListMultimap<String, Parameter> groupByFirstNameComponent(List<Parameter> parameters) {
        ArrayListMultimap firstNameComponentToParameterMap = ArrayListMultimap.create();
        for (Parameter parameter : parameters) {
            firstNameComponentToParameterMap.put((Object)parameter.getFirstNameComponent(), (Object)parameter);
        }
        return Multimaps.unmodifiableListMultimap((ListMultimap)firstNameComponentToParameterMap);
    }

    public List<Parameter> forTarget(Target<?> target) {
        return this.parametersByFirstNameComponent.get((Object)target.getName());
    }

    public Parameter namedAfter(Target<?> target) {
        List named = this.parametersByFirstNameComponent.get((Object)target.getName());
        this.assertFoundAtMostOneTarget(target, named);
        return named.isEmpty() ? new Parameter(target.getName(), "") : (Parameter)named.iterator().next();
    }

    private void assertFoundAtMostOneTarget(Target<?> target, Collection<Parameter> named) {
        if (named.size() > 1) {
            throw new IllegalStateException("Expecting only one parameter named after " + target + ", found instead " + named);
        }
    }

    public Parameters focusedOn(Target<?> target) {
        List<Parameter> relevantParameters = this.forTarget(target);
        ArrayList striped = Lists.newArrayListWithCapacity((int)relevantParameters.size());
        for (Parameter parameter : relevantParameters) {
            striped.add(parameter.strip());
        }
        return new Parameters(striped);
    }

    public Parameters notUsedBy(ClassConstructor aConstructor) {
        Sets.SetView namesNotUsedBy = Sets.difference(this.firstComponents(), aConstructor.getNames());
        ArrayList<Parameter> unusedParameters = new ArrayList<Parameter>();
        for (String name : namesNotUsedBy) {
            unusedParameters.addAll(this.parametersByFirstNameComponent.get((Object)name));
        }
        return new Parameters(unusedParameters);
    }

    private Set<String> firstComponents() {
        return this.parametersByFirstNameComponent.keySet();
    }

    public boolean hasRelatedTo(Target<?> target) {
        return !this.forTarget(target).isEmpty();
    }

    public String signatureString() {
        return "(" + Joiner.on((String)", ").join(this.getParametersList()) + ")";
    }

    public String toString() {
        return "Parameters" + this.signatureString();
    }

    public int hashCode() {
        return this.parametersByFirstNameComponent.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)obj;
        return this.parametersByFirstNameComponent.equals(other.parametersByFirstNameComponent);
    }

    Collection<Parameter> getParametersList() {
        return this.parametersByFirstNameComponent.values();
    }
}

