/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.conversion;

import br.com.caelum.iogi.conversion.TypeConverter;
import br.com.caelum.iogi.exceptions.ConversionException;
import br.com.caelum.iogi.reflection.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
extends TypeConverter<Object> {
    @Override
    public boolean isAbleToInstantiate(Target<?> target) {
        return Enum.class.isAssignableFrom(target.getClassType());
    }

    @Override
    protected Object convert(String stringValue, Target<?> to) {
        this.ensureTargetIsAnEnum(to);
        Class<?> enumClass = to.getClassType();
        if (this.isNumber(stringValue)) {
            return this.instantiateFromOrdinal(enumClass, stringValue, to);
        }
        return this.instantiateFromName(enumClass, stringValue, to);
    }

    private void ensureTargetIsAnEnum(Target<?> to) {
        if (!Enum.class.isAssignableFrom(to.getClassType())) {
            throw new ConversionException("Target %s does not represent a Java enum.", to);
        }
    }

    private boolean isNumber(String stringValue) {
        for (int i = 0; i < stringValue.length(); ++i) {
            if (Character.isDigit(stringValue.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Object instantiateFromOrdinal(Class<?> enumClass, String ordinalAsString, Target<?> to) {
        try {
            ?[] enumConstants = enumClass.getEnumConstants();
            int ordinal = Integer.parseInt(ordinalAsString);
            return enumConstants[ordinal];
        }
        catch (Exception e) {
            throw new ConversionException("Failed to interpret '%s' as an ordinal index into enum '%s' (when trying to fulfill target %s)", ordinalAsString, enumClass.getName(), to);
        }
    }

    private Object instantiateFromName(Class<?> type, String name, Target<?> to) {
        try {
            Class<?> enumClass = type;
            return Enum.valueOf(enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("Attempted to convert '%s' to an enum value of type '%s' (when trying to fulfill target %s)", name, type.getName(), to);
        }
    }
}

