/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.collections;

import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.Target;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParametersByIndex {
    private static final Pattern firstComponentPattern = Pattern.compile("[^\\[]+\\[(\\d+)\\]");
    private final ListMultimap<Integer, Parameter> firstComponentToParameterMap;

    public ParametersByIndex(Parameters parameters, Target<?> target) {
        this.firstComponentToParameterMap = this.groupByIndex(parameters, target);
    }

    private ListMultimap<Integer, Parameter> groupByIndex(Parameters parameters, Target<?> target) {
        LinkedListMultimap map = LinkedListMultimap.create();
        for (Parameter parameter : parameters.forTarget(target)) {
            Integer index = this.extractIndexOrReturnNull(parameter);
            if (index == null) continue;
            map.put((Object)index, (Object)parameter);
        }
        return Multimaps.unmodifiableListMultimap((ListMultimap)map);
    }

    private Integer extractIndexOrReturnNull(Parameter parameter) {
        Matcher matcher = firstComponentPattern.matcher(parameter.getFirstNameComponentWithDecoration());
        return matcher.find() ? Integer.valueOf(matcher.group(1)) : null;
    }

    public Collection<Integer> indexes() {
        return this.firstComponentToParameterMap.keySet();
    }

    public boolean isEmpty() {
        return this.firstComponentToParameterMap.isEmpty();
    }

    public Parameters at(int index) {
        return new Parameters(this.firstComponentToParameterMap.get((Object)index));
    }

    public int count() {
        return this.firstComponentToParameterMap.values().size();
    }
}

