/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.reflection;

import br.com.caelum.iogi.DependenciesInjector;
import br.com.caelum.iogi.reflection.ClassConstructor;
import br.com.caelum.iogi.reflection.Constructors;
import br.com.caelum.iogi.spi.ParameterNamesProvider;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target<T> {
    private final Type type;
    private final String name;

    public static <T> Target<T> create(Class<T> type, String name) {
        return new Target<T>(type, name);
    }

    public Target(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Class<T> getClassType() {
        return this.findRawClassType(this.type);
    }

    private Class<T> findRawClassType(Type type) {
        if (type instanceof ParameterizedType) {
            return this.findRawClassType(((ParameterizedType)type).getRawType());
        }
        return (Class)type;
    }

    public String getName() {
        return this.name;
    }

    public T cast(Object object) {
        if (this.getClassType().isPrimitive()) {
            return Primitives.primitiveCast(object, this.getClassType());
        }
        return this.getClassType().cast(object);
    }

    public boolean isInstantiable() {
        return !this.getClassType().isInterface() && !Modifier.isAbstract(this.getClassType().getModifiers()) && this.getClassType() != Void.class;
    }

    public Type getType() {
        return this.type;
    }

    public Target<Object> typeArgument(int index) {
        ParameterizedType thisAsParameterizedType = (ParameterizedType)this.getType();
        Type[] typeArguments = thisAsParameterizedType.getActualTypeArguments();
        Type typeArgument = typeArguments[index];
        return new Target<Object>(typeArgument, this.getName());
    }

    public Class<?> arrayElementType() {
        return this.getClassType().getComponentType();
    }

    public Target<?> arrayElementTarget() {
        return Target.create(this.arrayElementType(), this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return String.format("Target(name=%s, type=%s)", this.name, this.getClassType());
    }

    public Constructors constructors(ParameterNamesProvider parameterNamesProvider, DependenciesInjector dependenciesInjector) {
        HashSet<ClassConstructor> classConstructors = new HashSet<ClassConstructor>();
        for (Constructor<?> constructor : this.getClassType().getDeclaredConstructors()) {
            classConstructors.add(new ClassConstructor(constructor, parameterNamesProvider));
        }
        return new Constructors(classConstructors, dependenciesInjector);
    }

    public boolean isParameterized() {
        return this.getType() instanceof ParameterizedType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Primitives {
        private static final Map<Class<?>, Class<?>> primitiveToObject = ImmutableMap.builder().put(Boolean.TYPE, Boolean.class).put(Character.TYPE, Character.class).put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Void.TYPE, Void.class).build();

        private Primitives() {
        }

        public static <T> T primitiveCast(Object object, Class<T> type) {
            return (T)primitiveToObject.get(type).cast(object);
        }
    }
}

