/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.reflection;

import br.com.caelum.iogi.DependenciesInjector;
import br.com.caelum.iogi.Instantiator;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.NewObject;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.ParameterNamesProvider;
import br.com.caelum.iogi.util.IogiCollections;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassConstructor {
    private final Set<String> names;
    private final Constructor<?> constructor;

    public ClassConstructor(Constructor<?> constructor, ParameterNamesProvider parameterNamesProvider) {
        this(constructor, Sets.newLinkedHashSet(parameterNamesProvider.lookupParameterNames(constructor)));
    }

    private ClassConstructor(Constructor<?> constructor, Set<String> names) {
        this.constructor = constructor;
        this.names = names;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public int size() {
        return this.names.size();
    }

    public NewObject instantiate(Instantiator<?> argumentsInstantiator, Parameters parameters, DependenciesInjector dependenciesInjector) {
        ArrayList argumentValues = Lists.newArrayListWithCapacity((int)this.size());
        Collection<Target<?>> needDependency = this.notFulfilledBy(parameters);
        for (Target<?> target : this.argumentTargets()) {
            Object value = needDependency.contains(target) ? dependenciesInjector.provide(target) : argumentsInstantiator.instantiate(target, parameters);
            argumentValues.add(value);
        }
        Object newObjectValue = new Mirror().on(this.declaringClass()).invoke().constructor(this.constructor).withArgs(argumentValues.toArray());
        return new NewObject(argumentsInstantiator, parameters.notUsedBy(this), newObjectValue);
    }

    public Collection<Target<?>> notFulfilledBy(Parameters parameters) {
        ArrayList unfulfilledParameterTargets = new ArrayList();
        for (Target<?> parameterTarget : this.argumentTargets()) {
            if (parameters.hasRelatedTo(parameterTarget)) continue;
            unfulfilledParameterTargets.add(parameterTarget);
        }
        return Collections.unmodifiableList(unfulfilledParameterTargets);
    }

    public List<Target<?>> argumentTargets() {
        List<Type> types = Arrays.asList(this.constructor.getGenericParameterTypes());
        ArrayList targets = Lists.newArrayList();
        for (Map.Entry<Type, String> parameter : IogiCollections.zip(types, this.names)) {
            targets.add(new Target(parameter.getKey(), parameter.getValue()));
        }
        return Collections.unmodifiableList(targets);
    }

    public Class<?> declaringClass() {
        return this.constructor.getDeclaringClass();
    }

    public String toString() {
        return "(" + Joiner.on((String)", ").join(this.names) + ")";
    }

    public boolean canInstantiateOrInject(Parameters relevantParameters, DependenciesInjector dependenciesInjector) {
        Collection<Target<?>> uninstantiableByParameters = this.notFulfilledBy(relevantParameters);
        boolean canObtainDependencies = dependenciesInjector.canObtainDependenciesFor(uninstantiableByParameters);
        return canObtainDependencies;
    }

    public Object construct(List<Object> argumentValues) {
        return new Mirror().on(this.declaringClass()).invoke().constructor(this.constructor).withArgs(argumentValues.toArray());
    }
}

