/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.parameters;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    private static final Pattern DECORATION_REGEX = Pattern.compile("\\[\\d+\\]$");
    private final String value;
    private final ImmutableList<String> nameComponents;

    public Parameter(String name, String value) {
        this(Parameter.notNull(value, "Parameter value"), Parameter.computeNameComponents(Parameter.notNull(name, "Parameter name")));
    }

    private Parameter(String value, ImmutableList<String> nameComponents) {
        this.value = value;
        this.nameComponents = nameComponents;
    }

    private static <T> T notNull(T object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return object;
    }

    private static ImmutableList<String> computeNameComponents(String name) {
        return ImmutableList.of((Object[])name.split("\\."));
    }

    public String getName() {
        return Joiner.on((String)".").join(this.nameComponents);
    }

    public String getValue() {
        return this.value;
    }

    public String getFirstNameComponentWithDecoration() {
        return (String)this.nameComponents.get(0);
    }

    public String getFirstNameComponent() {
        String first = this.getFirstNameComponentWithDecoration();
        return DECORATION_REGEX.matcher(first).replaceAll("");
    }

    public Parameter strip() {
        if (this.nameComponents.size() < 2) {
            return null;
        }
        ImmutableList componentsExceptTheFirst = this.nameComponents.subList(1, this.nameComponents.size());
        return new Parameter(this.value, (ImmutableList<String>)componentsExceptTheFirst);
    }

    public boolean isDecorated() {
        return DECORATION_REGEX.matcher(this.getFirstNameComponentWithDecoration()).find();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameComponents == null ? 0 : this.nameComponents.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.nameComponents == null ? other.nameComponents != null : !this.nameComponents.equals(other.nameComponents)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return String.format("Parameter(%s -> %s)", this.getName(), this.getValue());
    }
}

