/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.conversion;

import br.com.caelum.iogi.conversion.TypeConverter;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.LocaleProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleBasedCalendarConverter
extends TypeConverter<Calendar> {
    private final LocaleProvider localeProvider;

    public LocaleBasedCalendarConverter(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public boolean isAbleToInstantiate(Target<?> target) {
        return target.getClassType() == Calendar.class;
    }

    @Override
    protected Calendar convert(String stringValue, Target<?> to) throws ParseException {
        Locale locale = this.providedOrDefault();
        DateFormat format = DateFormat.getDateInstance(3, locale);
        Date date = format.parse(stringValue);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        return calendar;
    }

    private Locale providedOrDefault() {
        Locale locale = this.localeProvider.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

