/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.iogi.collections;

import br.com.caelum.iogi.Instantiator;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.util.Assert;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclingListInstantiator
implements Instantiator<List<Object>> {
    private final Instantiator<Object> elementInstantiator;

    public CyclingListInstantiator(Instantiator<Object> objectInstantiator) {
        this.elementInstantiator = objectInstantiator;
    }

    @Override
    public boolean isAbleToInstantiate(Target<?> target) {
        return target.getClassType().isAssignableFrom(List.class);
    }

    @Override
    public List<Object> instantiate(Target<?> target, Parameters parameters) {
        Assert.isNotARawType(target);
        Target<Object> listElementTarget = target.typeArgument(0);
        Collection<List<Parameter>> parameterLists = this.breakList(parameters.forTarget(target));
        ArrayList newList = Lists.newArrayListWithExpectedSize((int)parameterLists.size());
        for (List<Parameter> parameterListForAnElement : parameterLists) {
            Object listElement = this.elementInstantiator.instantiate(listElementTarget, new Parameters(parameterListForAnElement));
            newList.add(listElement);
        }
        return newList;
    }

    private Collection<List<Parameter>> breakList(List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        int listSize = this.countToFirstRepeatedParameterName(parameters);
        return Lists.partition(parameters, (int)listSize);
    }

    private int countToFirstRepeatedParameterName(List<Parameter> parameters) {
        int count = 1;
        ListIterator<Parameter> parametersIterator = parameters.listIterator();
        String firstParameterName = parametersIterator.next().getName();
        while (parametersIterator.hasNext() && !parametersIterator.next().getName().equals(firstParameterName)) {
            ++count;
        }
        return count;
    }
}

