/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.financeiro.domain;

import java.math.BigDecimal;
import java.util.Objects;

public class Product {
    private String description;
    private Integer quantity;
    private BigDecimal price;
    private String NCMCode;
    private Integer durationInDays;
    private String type;

    private Product() {
    }

    public Product(String description, Integer quantity, BigDecimal price, String NCMCode, Integer durationInDays, String type) {
        this.description = description;
        this.quantity = quantity;
        this.price = price;
        this.NCMCode = NCMCode;
        this.durationInDays = durationInDays;
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.quantity, this.price);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Product other = (Product)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.price, other.price);
    }

    public String toString() {
        return "Product[Description: " + this.description + "]";
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getNCMCode() {
        return this.NCMCode;
    }

    public Integer getDurationInDays() {
        return this.durationInDays;
    }

    public String getType() {
        return this.type;
    }

    public BigDecimal getTotalPrice() {
        return this.price.multiply(BigDecimal.valueOf(this.quantity.intValue()));
    }
}

