/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.financeiro.domain;

import br.com.caelum.financeiro.domain.Customer;
import br.com.caelum.financeiro.domain.Product;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public class Transaction {
    private Long id;
    private LocalDate date;
    private Customer customer;
    private List<Product> products;
    private LocalDate accessDate;
    private String paymentMethod;
    private Integer numberOfInstallments;
    private Boolean renewal;

    private Transaction() {
    }

    public Transaction(Long id, LocalDate date, Customer customer, List<Product> products, LocalDate accessDate, String paymentMethod, Integer numberOfInstallments, Boolean renewal) {
        this.id = id;
        this.date = date;
        this.customer = customer;
        this.products = products;
        this.accessDate = accessDate;
        this.paymentMethod = paymentMethod;
        this.numberOfInstallments = numberOfInstallments;
        this.renewal = renewal;
    }

    public int hashCode() {
        return Objects.hash(this.date, this.customer, this.products);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.customer, other.customer) && Objects.equals(this.products, other.products);
    }

    public String toString() {
        return "Payment[Date: " + this.date + " Customer: " + this.customer + "]";
    }

    public Long getId() {
        return this.id;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public LocalDate getAccessDate() {
        return this.accessDate;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public Integer getNumberOfInstallments() {
        return this.numberOfInstallments;
    }

    public Boolean getRenewal() {
        return this.renewal;
    }

    public BigDecimal getTotalAmount() {
        return this.products.stream().map(Product::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public String getDescription() {
        return this.products.stream().map(Product::getDescription).reduce(" ", String::concat);
    }
}

