package br.com.brjdevs.java.utils.strings;

import br.com.brjdevs.java.utils.annotations.Incubating;
import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

@Incubating
@MissingDocumentation
public class Splitters {
	public static class PatternBasedBuilder {
		private final Pattern pattern;
		private UnaryOperator<String[]> processer = UnaryOperator.identity();
		private Function<String, String[]> splitter;

		private PatternBasedBuilder(Pattern pattern) {
			this.pattern = pattern;
			splitter = pattern::split;
		}

		public Function<String, String[]> asFunction() {
			return splitter.andThen(processer);
		}

		public PatternBasedBuilder limitSize(int size) {
			splitter = s -> pattern.split(s, size);

			return this;
		}

		public PatternBasedBuilder normalize(int size) {
			processer = s -> StringUtils.normalizeArray(s, size);

			return this;
		}
	}

	public static PatternBasedBuilder of(String pattern) {
		return of(Pattern.compile(pattern));
	}

	private static PatternBasedBuilder of(Pattern pattern) {
		return new PatternBasedBuilder(pattern);
	}
}