package br.com.brjdevs.java.utils.functions.advanced;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;
import br.com.brjdevs.java.utils.functions.TriConsumer;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@MissingDocumentation
public interface AdvancedTriConsumer<T, U, V> extends TriConsumer<T, U, V> {
	static <T, U, V> AdvancedTriConsumer<T, U, V> of(TriConsumer<T, U, V> wrapped) {
		return wrapped::accept;
	}

	@Override
	default AdvancedTriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
		Objects.requireNonNull(after);

		return (t, u, v) -> {
			accept(t, u, v);
			after.accept(t, u, v);
		};
	}

	default <W, X, Y> AdvancedTriConsumer<W, X, Y> compose(Function<? super W, ? extends T> before1, Function<? super X, ? extends U> before2, Function<? super Y, ? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return (w, x, y) -> accept(before1.apply(w), before2.apply(x), before3.apply(y));
	}

	default <X, Y> AdvancedBiConsumer<X, Y> compose(Supplier<? extends T> before1, Function<? super X, ? extends U> before2, Function<? super Y, ? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return (x, y) -> accept(before1.get(), before2.apply(x), before3.apply(y));
	}

	default <W, Y> AdvancedBiConsumer<W, Y> compose(Function<? super W, ? extends T> before1, Supplier<? extends U> before2, Function<? super Y, ? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return (w, y) -> accept(before1.apply(w), before2.get(), before3.apply(y));
	}

	default <W, X> AdvancedBiConsumer<W, X> compose(Function<? super W, ? extends T> before1, Function<? super X, ? extends U> before2, Supplier<? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return (w, x) -> accept(before1.apply(w), before2.apply(x), before3.get());
	}

	default <Y> AdvancedConsumer<Y> compose(Supplier<? extends T> before1, Supplier<? extends U> before2, Function<? super Y, ? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return y -> accept(before1.get(), before2.get(), before3.apply(y));
	}

	default <X> AdvancedConsumer<X> compose(Supplier<? extends T> before1, Function<? super X, ? extends U> before2, Supplier<? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return x -> accept(before1.get(), before2.apply(x), before3.get());
	}

	default <W> AdvancedConsumer<W> compose(Function<? super W, ? extends T> before1, Supplier<? extends U> before2, Supplier<? extends V> before3) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		Objects.requireNonNull(before3);
		return w -> accept(before1.apply(w), before2.get(), before3.get());
	}

	default AdvancedRunnable supply(Supplier<? extends T> supplier1, Supplier<? extends U> supplier2, Supplier<? extends V> supplier3) {
		Objects.requireNonNull(supplier1);
		Objects.requireNonNull(supplier2);
		Objects.requireNonNull(supplier3);

		return () -> accept(supplier1.get(), supplier2.get(), supplier3.get());
	}

	default AdvancedBiConsumer<U, V> supplyFirst(Supplier<? extends T> supplier) {
		Objects.requireNonNull(supplier);

		return (u, v) -> accept(supplier.get(), u, v);
	}

	default AdvancedBiConsumer<T, V> supplySecond(Supplier<? extends U> supplier) {
		Objects.requireNonNull(supplier);

		return (t, v) -> accept(t, supplier.get(), v);
	}

	default AdvancedBiConsumer<T, U> supplyThird(Supplier<? extends V> supplier) {
		Objects.requireNonNull(supplier);

		return (t, u) -> accept(t, u, supplier.get());
	}
}
