/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.collections.functional;

import br.com.brjdevs.java.utils.collections.functional.ChainMapWrapper;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;

public interface ChainMap<K, V> {
    public static <K, V> ChainMap<K, V> of(Map<K, V> map) {
        return new ChainMapWrapper<K, V>(map);
    }

    public Map<K, V> asMap();

    public ChainMap<K, V> asMap(Consumer<Map<K, V>> var1);

    public ChainMap<K, V> clear();

    public ChainMap<K, V> containsKey(K var1, Consumer<Boolean> var2);

    public ChainMap<K, V> containsValue(V var1, Consumer<Boolean> var2);

    public ChainMap<K, V> entrySet(Consumer<Set<Map.Entry<K, V>>> var1);

    public ChainMap<K, V> get(K var1, Consumer<V> var2);

    public ChainMap<K, V> isEmpty(Consumer<Boolean> var1);

    public ChainMap<K, V> keySet(Consumer<Set<K>> var1);

    public ChainMap<K, V> put(K var1, V var2, Consumer<V> var3);

    public ChainMap<K, V> putAll(Map<? extends K, ? extends V> var1);

    public ChainMap<K, V> remove(K var1, Consumer<V> var2);

    public ChainMap<K, V> size(IntConsumer var1);

    public ChainMap<K, V> values(Consumer<Collection<V>> var1);

    default public ChainMap<K, V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, r -> {});
    }

    default public ChainMap<K, V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Consumer<V> result) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(result);
        return this.get(key, oldValue -> {
            Object newValue = remappingFunction.apply((K)key, (V)oldValue);
            if (newValue == null) {
                if (oldValue != null || this.asMap().containsKey(key)) {
                    this.remove(key);
                }
                result.accept(null);
            } else {
                this.put(key, newValue);
                result.accept(newValue);
            }
        });
    }

    default public ChainMap<K, V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, r -> {});
    }

    default public ChainMap<K, V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Consumer<V> result) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(result);
        return this.get(key, v -> {
            Object newValue;
            if (v == null && (newValue = mappingFunction.apply((K)key)) != null) {
                this.put(key, newValue);
            }
        });
    }

    default public ChainMap<K, V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, r -> {});
    }

    default public ChainMap<K, V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Consumer<V> result) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(result);
        return this.get(key, oldValue -> {
            if (oldValue != null) {
                Object newValue = remappingFunction.apply((K)key, (V)oldValue);
                if (newValue != null) {
                    this.put(key, newValue);
                    result.accept(newValue);
                    return;
                }
                this.remove(key);
                result.accept(null);
                return;
            }
            result.accept(null);
        });
    }

    default public ChainMap<K, V> forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        return this.entrySet(entrySet -> {
            for (Map.Entry entry : entrySet) {
                Object v;
                Object k;
                try {
                    k = entry.getKey();
                    v = entry.getValue();
                }
                catch (IllegalStateException ise) {
                    throw new ConcurrentModificationException(ise);
                }
                action.accept((Object)k, (Object)v);
            }
        });
    }

    default public ChainMap<K, V> getOrDefault(K key, V defaultValue, Consumer<V> value) {
        Objects.requireNonNull(value);
        return this.get(key, v -> {
            if (v != null) {
                value.accept(v);
                return;
            }
            this.containsKey(key, b -> value.accept(b != false ? null : defaultValue));
        });
    }

    default public ChainMap<K, V> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge(key, value, remappingFunction, r -> {});
    }

    default public ChainMap<K, V> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Consumer<V> result) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        Objects.requireNonNull(result);
        return this.get(key, oldValue -> {
            Object newValue;
            Object object = newValue = oldValue == null ? value : remappingFunction.apply((V)oldValue, (V)value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            result.accept(newValue);
        });
    }

    default public ChainMap<K, V> put(K key, V value) {
        return this.put(key, value, r -> {});
    }

    default public ChainMap<K, V> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, r -> {});
    }

    default public ChainMap<K, V> putIfAbsent(K key, V value, Consumer<V> result) {
        Objects.requireNonNull(result);
        return this.get(key, v -> {
            if (v == null) {
                this.put(key, value, result);
            } else {
                result.accept(v);
            }
        });
    }

    default public ChainMap<K, V> remove(K key) {
        return this.remove(key, (V)((Consumer<Object>)r -> {}));
    }

    default public ChainMap<K, V> remove(K key, V value) {
        return this.remove(key, value, r -> {});
    }

    default public ChainMap<K, V> remove(K key, V value, Consumer<Boolean> result) {
        Objects.requireNonNull(result);
        return this.get(key, curValue -> this.containsKey(key, containsKey -> {
            if (!Objects.equals(curValue, value) || curValue == null && !containsKey.booleanValue()) {
                result.accept(false);
                return;
            }
            this.remove(key);
            result.accept(true);
        }));
    }

    default public ChainMap<K, V> replace(K key, V oldValue, V newValue, Consumer<Boolean> result) {
        Objects.requireNonNull(result);
        return this.get(key, curValue -> this.containsKey(key, containsKey -> {
            if (!Objects.equals(curValue, oldValue) || curValue == null && !containsKey.booleanValue()) {
                result.accept(false);
            }
            this.put(key, newValue);
            result.accept(true);
        }));
    }

    default public ChainMap<K, V> replace(K key, V value, Consumer<V> result) {
        Objects.requireNonNull(result);
        return this.get(key, curValue -> this.containsKey(key, containsKey -> {
            if (curValue != null || containsKey.booleanValue()) {
                this.put(key, value, result);
                return;
            }
            result.accept(null);
        }));
    }

    default public ChainMap<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        return this.entrySet(entrySet -> {
            for (Map.Entry entry : entrySet) {
                Object v;
                Object k;
                try {
                    k = entry.getKey();
                    v = entry.getValue();
                }
                catch (IllegalStateException ise) {
                    throw new ConcurrentModificationException(ise);
                }
                v = function.apply((Object)k, (Object)v);
                try {
                    entry.setValue(v);
                }
                catch (IllegalStateException ise) {
                    throw new ConcurrentModificationException(ise);
                }
            }
        });
    }
}

