package br.com.brjdevs.java.utils.functions.advanced;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@MissingDocumentation
public interface AdvancedSupplier<T> extends Supplier<T> {
	static <V> AdvancedSupplier<V> of(Supplier<V> wrapped) {
		return wrapped::get;
	}

	default Optional<T> getOptionally() {
		return Optional.ofNullable(get());
	}

	default <V> AdvancedSupplier<V> map(Function<T, V> map) {
		Objects.requireNonNull(map);
		return () -> map.apply(this.get());
	}

	default Stream<T> stream() {
		return Stream.generate(this);
	}
}
