/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.strings;

import br.com.brjdevs.java.utils.strings.StringUtils;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

public class Splitters {
    public static PatternBasedBuilder of(String pattern) {
        return Splitters.of(Pattern.compile(pattern));
    }

    private static PatternBasedBuilder of(Pattern pattern) {
        return new PatternBasedBuilder(pattern);
    }

    public static class PatternBasedBuilder {
        private final Pattern pattern;
        private UnaryOperator<String[]> processer = UnaryOperator.identity();
        private Function<String, String[]> splitter;

        private PatternBasedBuilder(Pattern pattern) {
            this.pattern = pattern;
            this.splitter = pattern::split;
        }

        public Function<String, String[]> asFunction() {
            return this.splitter.andThen(this.processer);
        }

        public PatternBasedBuilder limitSize(int size) {
            this.splitter = s -> this.pattern.split((CharSequence)s, size);
            return this;
        }

        public PatternBasedBuilder normalize(int size) {
            this.processer = s -> StringUtils.normalizeArray(s, size);
            return this;
        }
    }
}

