/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.extensions;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Async {
    public static Thread current() {
        return Thread.currentThread();
    }

    public static void sleep(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void task(String task, Runnable scheduled, int everySeconds) {
        Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static void task(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static Thread thread(int sleepMilis, Runnable doAfter) {
        return Async.thread(() -> {
            Async.sleep(sleepMilis);
            if (doAfter != null) {
                doAfter.run();
            }
        });
    }

    public static Thread thread(String name, Runnable doAsync) {
        Thread thread = new Thread(doAsync, name);
        thread.start();
        return thread;
    }

    private static Thread thread(Runnable doAsync) {
        Thread thread = new Thread(doAsync);
        thread.start();
        return thread;
    }
}

