package br.com.brjdevs.java.utils.functions.advanced;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@MissingDocumentation
public interface AdvancedConsumer<T> extends Consumer<T> {
	static <V> AdvancedConsumer<V> of(Consumer<V> wrapped) {
		return wrapped::accept;
	}

	@Override
	default AdvancedConsumer<T> andThen(Consumer<? super T> after) {
		Objects.requireNonNull(after);
		return (T t) -> {
			accept(t);
			after.accept(t);
		};
	}

	default <V> AdvancedConsumer<V> compose(Function<? super V, ? extends T> before) {
		Objects.requireNonNull(before);
		return (V v) -> accept(before.apply(v));
	}

	default AdvancedRunnable supply(Supplier<? extends T> supplier) {
		Objects.requireNonNull(supplier);

		return () -> accept(supplier.get());
	}
}
