package br.com.brjdevs.java.utils.functions.advanced;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

@MissingDocumentation
public interface AdvancedBiConsumer<T, U> extends BiConsumer<T, U> {
	static <V, W> AdvancedBiConsumer<V, W> of(BiConsumer<V, W> wrapped) {
		return wrapped::accept;
	}

	@Override
	default AdvancedBiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
		Objects.requireNonNull(after);

		return (l, r) -> {
			accept(l, r);
			after.accept(l, r);
		};
	}

	default <V, W> AdvancedBiConsumer<V, W> compose(Function<? super V, ? extends T> before1, Function<? super W, ? extends U> before2) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		return (V v, W w) -> accept(before1.apply(v), before2.apply(w));
	}

	default <V> AdvancedConsumer<V> compose(Supplier<? extends T> before1, Function<? super V, ? extends U> before2) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		return (V v) -> accept(before1.get(), before2.apply(v));
	}

	default <V> AdvancedConsumer<V> compose(Function<? super V, ? extends T> before1, Supplier<? extends U> before2) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		return (V v) -> accept(before1.apply(v), before2.get());
	}

	default <V, W> AdvancedBiConsumer<V, W> compose(BiFunction<? super V, ? super W, ? extends T> before1, BiFunction<? super V, ? super W, ? extends U> before2) {
		Objects.requireNonNull(before1);
		Objects.requireNonNull(before2);
		return (V v, W w) -> accept(before1.apply(v, w), before2.apply(v, w));
	}

	default AdvancedRunnable supply(Supplier<? extends T> supplier1, Supplier<? extends U> supplier2) {
		Objects.requireNonNull(supplier1);
		Objects.requireNonNull(supplier2);

		return () -> accept(supplier1.get(), supplier2.get());
	}

	default AdvancedConsumer<U> supplyFirst(Supplier<? extends T> supplier) {
		Objects.requireNonNull(supplier);

		return u -> accept(supplier.get(), u);
	}

	default AdvancedConsumer<T> supplySecond(Supplier<? extends U> supplier) {
		Objects.requireNonNull(supplier);

		return t -> accept(t, supplier.get());
	}
}
