package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.annotations.ExtensionClass;
import br.com.brjdevs.java.utils.annotations.MissingDocumentation;
import br.com.brjdevs.java.utils.functions.advanced.AdvancedBiConsumer;
import br.com.brjdevs.java.utils.functions.advanced.AdvancedConsumer;
import br.com.brjdevs.java.utils.functions.advanced.AdvancedRunnable;
import br.com.brjdevs.java.utils.functions.advanced.AdvancedSupplier;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ExtensionClass
@MissingDocumentation
public class FunctionUtils {
	public static AdvancedRunnable advanced(Runnable base) {
		return AdvancedRunnable.of(base);
	}

	public static <V> AdvancedConsumer<V> advanced(Consumer<V> base) {
		return AdvancedConsumer.of(base);
	}

	public static <V, W> AdvancedBiConsumer<V, W> advanced(BiConsumer<V, W> base) {
		return AdvancedBiConsumer.of(base);
	}

	public static <V> AdvancedSupplier<V> advanced(Supplier<V> base) {
		return AdvancedSupplier.of(base);
	}
}
