package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.annotations.ExtensionClass;
import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@MissingDocumentation
@ExtensionClass
public class Async {
	public static Thread current() {
		return Thread.currentThread();
	}

	public static void sleep(int milis) {
		try {
			Thread.sleep(milis);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Start an Async single thread task every x seconds. Replacement for Timer.
	 *
	 * @param task         The name of the task to run
	 * @param scheduled    The runnable.
	 * @param everySeconds the amount of seconds the task will take to loop.
	 */
	public static void task(String task, Runnable scheduled, int everySeconds) {
		Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0, everySeconds, TimeUnit.SECONDS);
	}

	public static void task(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
		ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
		executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0, everySeconds, TimeUnit.SECONDS);
	}

	public static Thread thread(final int sleepMilis, final Runnable doAfter) {
		return thread(() -> {
			sleep(sleepMilis);
			if (doAfter != null) doAfter.run();
		});
	}

	public static Thread thread(final String name, final Runnable doAsync) {
		Thread thread = new Thread(doAsync, name);
		thread.start();
		return thread;
	}

	private static Thread thread(final Runnable doAsync) {
		Thread thread = new Thread(doAsync);
		thread.start();
		return thread;
	}
}