package br.com.brjdevs.java.utils.collections.thread;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

@MissingDocumentation
public class DelegatedThreadMap<V> implements ThreadMap<V> {
	private static Thread current() {
		return Thread.currentThread();
	}

	private final Map<Thread, V> delegated;

	public DelegatedThreadMap(Map<Thread, V> delegated) {
		this.delegated = delegated;
	}

	@Override
	public V compute(BiFunction<? super Thread, ? super V, ? extends V> remappingFunction) {
		return compute(current(), remappingFunction);
	}

	@Override
	public V computeIfAbsent(Function<? super Thread, ? extends V> mappingFunction) {
		return computeIfAbsent(current(), mappingFunction);
	}

	@Override
	public V computeIfPresent(BiFunction<? super Thread, ? super V, ? extends V> remappingFunction) {
		return computeIfPresent(current(), remappingFunction);
	}

	@Override
	public boolean containsKey() {
		return containsKey(current());
	}

	@Override
	public void copy(Thread parent, Thread child) {
		delegated.put(child, delegated.get(parent));
	}

	@Override
	public V merge(V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
		return merge(current(), value, remappingFunction);
	}

	@Override
	public V put(V value) {
		return put(current(), value);
	}

	@Override
	public V putIfAbsent(V value) {
		return putIfAbsent(current(), value);
	}

	@Override
	public V remove() {
		return remove(current());
	}

	@Override
	public boolean removeValue(V value) {
		return remove(current(), value);
	}

	@Override
	public V replace(V value) {
		return replace(current(), value);
	}

	@Override
	public boolean replaceValue(V oldValue, V newValue) {
		return replace(current(), oldValue, newValue);
	}

	@Override
	public void setChild(Thread parent) {
		copy(parent, current());
	}

	@Override
	public void setParent(Thread child) {
		copy(current(), child);
	}

	@Override
	public void clear() {
		delegated.clear();
	}

	@Override
	public V get() {
		return delegated.get(Thread.currentThread());
	}

	@Override
	public int hashCode() {
		return delegated.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		return delegated.equals(o);
	}

	@Override
	public int size() {
		return delegated.size();
	}

	@Override
	public boolean isEmpty() {
		return delegated.isEmpty();
	}

	@Override
	public boolean containsKey(Object key) {
		return delegated.containsKey(key);
	}

	@Override
	public boolean containsValue(Object value) {
		return delegated.containsValue(value);
	}

	@Override
	public V get(Object key) {
		return delegated.get(key);
	}

	@Override
	public V put(Thread key, V value) {
		return delegated.put(key, value);
	}

	@Override
	public V remove(Object key) {
		return delegated.remove(key);
	}

	@Override
	public void putAll(Map<? extends Thread, ? extends V> m) {
		delegated.putAll(m);
	}

	@Override
	public Set<Thread> keySet() {
		return delegated.keySet();
	}

	@Override
	public Collection<V> values() {
		return delegated.values();
	}

	@Override
	public Set<Entry<Thread, V>> entrySet() {
		return delegated.entrySet();
	}

	@Override
	public V getOrDefault(Object key, V defaultValue) {
		return delegated.getOrDefault(key, defaultValue);
	}

	@Override
	public void forEach(BiConsumer<? super Thread, ? super V> action) {
		delegated.forEach(action);
	}

	@Override
	public void replaceAll(BiFunction<? super Thread, ? super V, ? extends V> function) {
		delegated.replaceAll(function);
	}

	@Override
	public V putIfAbsent(Thread key, V value) {
		return delegated.putIfAbsent(key, value);
	}

	@Override
	public boolean remove(Object key, Object value) {
		return delegated.remove(key, value);
	}

	@Override
	public boolean replace(Thread key, V oldValue, V newValue) {
		return delegated.replace(key, oldValue, newValue);
	}

	@Override
	public V replace(Thread key, V value) {
		return delegated.replace(key, value);
	}

	@Override
	public V computeIfAbsent(Thread key, Function<? super Thread, ? extends V> mappingFunction) {
		return delegated.computeIfAbsent(key, mappingFunction);
	}

	@Override
	public V computeIfPresent(Thread key, BiFunction<? super Thread, ? super V, ? extends V> remappingFunction) {
		return delegated.computeIfPresent(key, remappingFunction);
	}

	@Override
	public V compute(Thread key, BiFunction<? super Thread, ? super V, ? extends V> remappingFunction) {
		return delegated.compute(key, remappingFunction);
	}

	@Override
	public V merge(Thread key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
		return delegated.merge(key, value, remappingFunction);
	}
}
