package br.com.brjdevs.java.utils;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;
import br.com.brjdevs.java.utils.threads.ScheduledTaskProcessor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@MissingDocumentation
public class RateLimiter {
	private static final ScheduledTaskProcessor TASK_PROCESSOR = new ScheduledTaskProcessor("RateLimiter");

	private final Map<String, AtomicInteger> idsRateLimited = new HashMap<>();
	private final int max, timeout;

	public RateLimiter(int max, int timeout) {
		this.max = max;
		this.timeout = timeout;
	}

	public boolean process(String id) {
		AtomicInteger currentLimit = idsRateLimited.computeIfAbsent(id, k -> new AtomicInteger());
		if (currentLimit.get() >= max) return false;
		currentLimit.incrementAndGet();
		TASK_PROCESSOR.addTask(System.currentTimeMillis() + timeout, currentLimit::decrementAndGet);
		return true;
	}
}
