/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.holding.objects;

import java.util.concurrent.atomic.AtomicInteger;

public class Indexed<T> {
    private final int index;
    private final T value;

    public Indexed(int index, T value) {
        this.index = index;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public T getValue() {
        return this.value;
    }

    public static class Indexer {
        private final AtomicInteger indexer;

        public Indexer() {
            this(0);
        }

        public Indexer(int initialIndex) {
            this.indexer = new AtomicInteger(initialIndex);
        }

        public <T> Indexed<T> index(T t) {
            return new Indexed<T>(this.indexer.getAndIncrement(), t);
        }
    }
}

