/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.async.threads.builder;

import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;

public class ThreadBuilder
implements ThreadFactory,
Function<Runnable, Thread> {
    private Consumer<Thread> builder = thread -> {};

    @Override
    public Thread apply(Runnable runnable) {
        return this.build(runnable);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return this.build(runnable);
    }

    public Thread build(Runnable runnable) {
        Thread thread = new Thread(runnable);
        this.builder.accept(thread);
        return thread;
    }

    public ThreadBuilder setContextClassLoader(ClassLoader cl) {
        this.builder = this.builder.andThen((? super T thread) -> thread.setContextClassLoader(cl));
        return this;
    }

    public ThreadBuilder setDaemon(boolean on) {
        this.builder = this.builder.andThen((? super T thread) -> thread.setDaemon(on));
        return this;
    }

    public ThreadBuilder setName(String name) {
        this.builder = this.builder.andThen((? super T thread) -> thread.setName(name));
        return this;
    }

    public ThreadBuilder setPriority(int newPriority) {
        this.builder = this.builder.andThen((? super T thread) -> thread.setPriority(newPriority));
        return this;
    }

    public ThreadBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        this.builder = this.builder.andThen((? super T thread) -> thread.setUncaughtExceptionHandler(eh));
        return this;
    }

    public ThreadBuilder startAfterBuilt() {
        this.builder = this.builder.andThen(Thread::start);
        return this;
    }
}

