/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.async;

import br.com.brjdevs.java.utils.async.threads.ScheduledTaskProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RateLimiter {
    private static final ScheduledTaskProcessor TASK_PROCESSOR = new ScheduledTaskProcessor("RateLimiter");
    private final Map<String, AtomicInteger> idsRateLimited = new HashMap<String, AtomicInteger>();
    private final int max;
    private final int timeout;

    public RateLimiter(int max, int timeout) {
        this.max = max;
        this.timeout = timeout;
    }

    public boolean process(String id) {
        AtomicInteger currentLimit = this.idsRateLimited.computeIfAbsent(id, k -> new AtomicInteger());
        if (currentLimit.get() >= this.max) {
            return false;
        }
        currentLimit.incrementAndGet();
        TASK_PROCESSOR.addTask(System.currentTimeMillis() + (long)this.timeout, currentLimit::decrementAndGet);
        return true;
    }
}

