/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.async;

import br.com.brjdevs.java.utils.async.threads.CompletableThread;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Async {
    public static Thread current() {
        return Thread.currentThread();
    }

    public static <T> Future<T> future(String task, Callable<T> callable) {
        return new CompletableThread<T>(task, callable);
    }

    public static <T> Future<T> future(Callable<T> callable) {
        return new CompletableThread<T>(callable);
    }

    public static void sleep(long milis) {
        try {
            Thread.sleep(milis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long time, TimeUnit unit) {
        Async.sleep(unit.toMillis(time));
    }

    @Deprecated
    public static void task(String task, Runnable scheduled, int everySeconds) {
        Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0L, everySeconds, TimeUnit.SECONDS);
    }

    @Deprecated
    public static void task(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static ScheduledExecutorService task(String task, Consumer<ScheduledExecutorService> scheduled, long everyTime, TimeUnit unit) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0L, everyTime, unit);
        return executor;
    }

    public static ScheduledExecutorService task(String task, Runnable scheduled, long everyTime, TimeUnit unit) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        executor.scheduleAtFixedRate(scheduled, 0L, everyTime, unit);
        return executor;
    }

    public static ScheduledExecutorService task(Consumer<ScheduledExecutorService> scheduled, long everyTime, TimeUnit unit) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0L, everyTime, unit);
        return executor;
    }

    public static ScheduledExecutorService task(Runnable scheduled, long everyTime, TimeUnit unit) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(scheduled, 0L, everyTime, unit);
        return executor;
    }

    public static Thread thread(Runnable doAsync) {
        Thread thread = new Thread(doAsync);
        thread.start();
        return thread;
    }

    @Deprecated
    public static Thread thread(int sleepMilis, Runnable doAfter) {
        return Async.thread(sleepMilis, TimeUnit.MILLISECONDS, doAfter);
    }

    public static Thread thread(long time, TimeUnit unit, Runnable doAfter) {
        Objects.requireNonNull(doAfter);
        return Async.thread(() -> {
            Async.sleep(time, unit);
            doAfter.run();
        });
    }

    @Deprecated
    public static Thread thread(String name, int sleepMilis, Runnable doAfter) {
        return Async.thread(name, sleepMilis, TimeUnit.MILLISECONDS, doAfter);
    }

    public static Thread thread(String name, long time, TimeUnit unit, Runnable doAfter) {
        Objects.requireNonNull(doAfter);
        return Async.thread(name, () -> {
            Async.sleep(time, unit);
            doAfter.run();
        });
    }

    public static Thread thread(String name, Runnable doAsync) {
        Objects.requireNonNull(doAsync);
        Thread thread = new Thread(doAsync, name);
        thread.start();
        return thread;
    }
}

