/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.threads.CompletableThread;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Async {
    public static Thread current() {
        return Thread.currentThread();
    }

    public static <T> Future<T> future(String task, Callable<T> callable) {
        return new CompletableThread<T>(task, callable);
    }

    public static <T> Future<T> future(Callable<T> callable) {
        return new CompletableThread<T>(callable);
    }

    public static void sleep(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void task(String task, Runnable scheduled, int everySeconds) {
        Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static void task(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        executor.scheduleAtFixedRate(() -> scheduled.accept(executor), 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static Thread thread(Runnable doAsync) {
        Thread thread = new Thread(doAsync);
        thread.start();
        return thread;
    }

    public static Thread thread(int sleepMilis, Runnable doAfter) {
        return Async.thread(() -> {
            Async.sleep(sleepMilis);
            if (doAfter != null) {
                doAfter.run();
            }
        });
    }

    public static Thread thread(String name, int sleepMilis, Runnable doAfter) {
        return Async.thread(name, () -> {
            Async.sleep(sleepMilis);
            if (doAfter != null) {
                doAfter.run();
            }
        });
    }

    public static Thread thread(String name, Runnable doAsync) {
        Thread thread = new Thread(doAsync, name);
        thread.start();
        return thread;
    }
}

