package br.com.brjdevs.java.utils.functions.advanced;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.util.Objects;

@MissingDocumentation
public interface AdvancedRunnable extends Runnable {
	static AdvancedRunnable of(Runnable wrapped) {
		return wrapped::run;
	}

	default Runnable andThen(Runnable after) {
		Objects.requireNonNull(after);
		return () -> {
			this.run();
			after.run();
		};
	}
}
