/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.collections.functional.ChainMap;
import br.com.brjdevs.java.utils.collections.functional.ChainMapWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionUtils {
    public static <K, V> ChainMap<K, V> chainable(Map<K, V> map) {
        return new ChainMapWrapper<K, V>(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concat(Map<? extends K, ? extends V> ... maps) {
        return Arrays.stream(maps).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concat(BinaryOperator<V> resolver, Map<? extends K, ? extends V> ... maps) {
        return Arrays.stream(maps).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, resolver));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concat(Supplier<Map<K, V>> mapSupplier, BinaryOperator<V> resolver, Map<? extends K, ? extends V> ... maps) {
        return Arrays.stream(maps).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, resolver, mapSupplier));
    }

    public static Function<String, Iterable<String>> iterable(Pattern pattern) {
        return s -> CollectionUtils.iterable(pattern, s);
    }

    public static Iterable<String> iterable(Pattern pattern, String string) {
        return () -> {
            final Matcher matcher = pattern.matcher(string);
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return matcher.find();
                }

                @Override
                public String next() {
                    return matcher.group();
                }
            };
        };
    }

    public static <T, R> List<R> map(List<T> list, Function<T, R> mapper) {
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T> T random(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public static <T> T random(T[] array, Random random) {
        return array[random.nextInt(array.length)];
    }

    public static <T> T random(List<T> list) {
        return list.get(CollectionUtils.random(list.size()));
    }

    public static <T> T random(T[] array) {
        return array[CollectionUtils.random(array.length)];
    }

    public static int random(int size) {
        return (int)Math.floor(Math.random() * (double)size);
    }

    public static <T> Comparator<T> randomOrder() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int x = r.nextInt();
        int y = r.nextInt();
        boolean b = r.nextBoolean();
        return Comparator.comparingInt(t -> t.hashCode() ^ x).thenComparingInt(s -> s.toString().length() ^ y);
    }

    @SafeVarargs
    public static <T> Stream<T> stream(T ... objs) {
        return Stream.of(objs);
    }

    public static <T> List<T> subListOn(List<T> list, Predicate<T> predicate) {
        Optional first = list.stream().filter(predicate).findFirst();
        return first.map(t -> list.subList(0, list.indexOf(t))).orElse(list);
    }

    public static <T> String toString(Collection<T> collection) {
        return CollectionUtils.toString(collection, Object::toString);
    }

    public static <T> String toString(Collection<T> collection, Function<T, String> toString) {
        return CollectionUtils.toString(collection, toString, "");
    }

    public static <T> String toString(Collection<T> collection, String join) {
        return CollectionUtils.toString(collection, Object::toString, join);
    }

    public static <T> String toString(Collection<T> collection, Function<T, String> toString, String join) {
        return collection.stream().map(toString).collect(Collectors.joining(join));
    }
}

