package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.annotations.ExtensionClass;
import br.com.brjdevs.java.utils.holding.Indexed;
import br.com.brjdevs.java.utils.holding.Indexed.Indexer;

import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@ExtensionClass
public class StreamUtils {
	public static <T> Function<T, Indexed<T>> index() {
		Indexer indexer = new Indexer();
		return indexer::index;
	}

	public static <T> Stream<T> stream(Iterable<T> iterable) {
		return stream(iterable, false);
	}

	public static <T> Stream<T> stream(Iterable<T> iterable, boolean parallel) {
		return StreamSupport.stream(iterable.spliterator(), parallel);
	}
}
