package br.com.brjdevs.java.utils.extensions;

import br.com.brjdevs.java.utils.annotations.ExtensionClass;
import br.com.brjdevs.java.utils.annotations.MissingDocumentation;
import br.com.brjdevs.java.utils.holding.Holder;
import br.com.brjdevs.java.utils.holding.Pointer;
import br.com.brjdevs.java.utils.holding.Switch;

@ExtensionClass
@MissingDocumentation
public class HoldingUtils {
	public static <T> Holder<T> hold(T obj) {
		return new Holder<>(obj);
	}

	public static <T> Pointer<T> point(T obj) {
		return new Pointer<T>(obj);
	}

	public static Switch switchFor(boolean value) {
		return new Switch(value);
	}
}
