package br.com.brjdevs.java.utils;

import br.com.brjdevs.java.utils.annotations.MissingDocumentation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@MissingDocumentation
public class EasyReflections {
	@SuppressWarnings("unchecked")
	private static class Internal {
		private static Field field(Class<?> c, String f) {
			try {
				return c.getDeclaredField(f);
			} catch (NoSuchFieldException e) {
				throw new IllegalArgumentException(e);
			}
		}

		private static <R> R get(Field field, Object object) {
			try {
				field.setAccessible(true);
				return (R) field.get(object);
			} catch (IllegalAccessException e) {
				throw new IllegalStateException(e);
			}
		}

		private static Method method(Class<?> c, String m) {
			try {
				return c.getDeclaredMethod(m);
			} catch (NoSuchMethodException e) {
				throw new IllegalArgumentException(e);
			}
		}

		private static void set(Field field, Object object, Object set) {
			try {
				field.setAccessible(true);
				field.set(object, set);
			} catch (IllegalAccessException e) {
				throw new IllegalStateException(e);
			}
		}

		private static void setFinal(Field field, Object object, Object set) {
			set(field(Field.class, "modifiers"), field, field.getModifiers() & ~Modifier.FINAL);
			set(field, object, set);
		}
	}

	public static <T, R> Function<T, R> getObjectField(Class<T> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return t -> Internal.get(field, t);
	}

	public static <R> Supplier<R> getStaticField(Class<?> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return () -> Internal.get(field, null);
	}

	public static <T, R> BiConsumer<T, R> setObjectField(Class<T> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return (t, r) -> Internal.set(field, t, r);
	}

	public static <T, R> BiConsumer<T, R> setObjectFinalField(Class<T> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return (t, r) -> Internal.set(field, t, r);
	}

	public static <R> Consumer<R> setStaticField(Class<?> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return r -> Internal.set(field, null, r);
	}

	public static <R> Consumer<R> setStaticFinalField(Class<?> clazz, String fieldName) {
		Field field = Internal.field(clazz, fieldName);
		return r -> Internal.set(field, null, r);
	}
}