/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.threads.builder;

import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

public class ThreadBuilder {
    private Consumer<Thread> builder = thread -> {};

    public ThreadBuilder setPriority(int newPriority) {
        this.builder.andThen(thread -> thread.setPriority(newPriority));
        return this;
    }

    public ThreadBuilder setName(String name) {
        this.builder.andThen(thread -> thread.setName(name));
        return this;
    }

    public ThreadBuilder setDaemon(boolean on) {
        this.builder.andThen(thread -> thread.setDaemon(on));
        return this;
    }

    public ThreadBuilder setContextClassLoader(ClassLoader cl) {
        this.builder.andThen(thread -> thread.setContextClassLoader(cl));
        return this;
    }

    public ThreadBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        this.builder.andThen(thread -> thread.setUncaughtExceptionHandler(eh));
        return this;
    }

    public Thread build(Runnable runnable) {
        Thread thread = new Thread(runnable);
        this.builder.accept(thread);
        return thread;
    }

    public ThreadFactory asFactory() {
        return this::build;
    }
}

