/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.threads;

import br.com.brjdevs.java.utils.Switch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ScheduledTaskProcessor {
    private final Map<Long, List<Runnable>> TASKS;
    private final Consumer<Runnable> onExpired;
    private boolean updated = false;

    public ScheduledTaskProcessor(Consumer<Runnable> onExpired, String name) {
        this.onExpired = onExpired;
        this.TASKS = new ConcurrentHashMap<Long, List<Runnable>>();
        Thread thread = new Thread(this::threadCode, name);
        thread.setDaemon(true);
        thread.start();
    }

    public ScheduledTaskProcessor(String name) {
        this(r -> new Thread((Runnable)r, "Scheduled Task Thread").start(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable addTask(long milis, Runnable onExpire) {
        Objects.requireNonNull(onExpire);
        this.TASKS.computeIfAbsent(milis, k -> new ArrayList()).add(onExpire);
        this.updated = true;
        ScheduledTaskProcessor scheduledTaskProcessor = this;
        synchronized (scheduledTaskProcessor) {
            this.notify();
        }
        return () -> {
            Switch r = new Switch();
            this.TASKS.computeIfPresent(milis, (k, v) -> {
                r.set(v.remove(onExpire));
                return v;
            });
            if (r.is(true)) {
                this.updated = true;
                ScheduledTaskProcessor scheduledTaskProcessor = this;
                synchronized (scheduledTaskProcessor) {
                    this.notify();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadCode() {
        while (true) {
            Map.Entry firstEntry;
            long timeout;
            if (this.TASKS.isEmpty()) {
                try {
                    ScheduledTaskProcessor scheduledTaskProcessor = this;
                    synchronized (scheduledTaskProcessor) {
                        this.wait();
                        this.updated = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((timeout = (Long)(firstEntry = (Map.Entry)this.TASKS.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).findFirst().orElse(null)).getKey() - System.currentTimeMillis()) > 0L) {
                ScheduledTaskProcessor scheduledTaskProcessor = this;
                synchronized (scheduledTaskProcessor) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.updated) {
                this.TASKS.remove(firstEntry.getKey());
                List runnables = (List)firstEntry.getValue();
                runnables.remove(null);
                runnables.forEach(this.onExpired);
                continue;
            }
            this.updated = false;
        }
    }
}

