/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.threads;

import java.util.Objects;

public class DeathTimer {
    private final Runnable onTimeout;
    private final long timeout;
    private boolean updated = false;
    private boolean armed = true;

    public DeathTimer(long timeout, Runnable onTimeout) {
        Objects.requireNonNull(onTimeout, "onTimeout");
        this.timeout = timeout;
        this.onTimeout = onTimeout;
        this.updated = true;
        Thread thread = new Thread(this::threadCode, "DeathTimer#" + Integer.toHexString(this.hashCode()) + " DThread");
        thread.setDaemon(true);
        thread.start();
    }

    public DeathTimer arm() {
        this.armed = true;
        return this;
    }

    public DeathTimer disarm() {
        this.armed = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeathTimer explode() {
        DeathTimer deathTimer = this;
        synchronized (deathTimer) {
            this.notify();
        }
        return this;
    }

    public DeathTimer reset() {
        this.updated = true;
        return this.explode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadCode() {
        while (this.updated) {
            this.updated = false;
            try {
                DeathTimer deathTimer = this;
                synchronized (deathTimer) {
                    this.wait(this.timeout);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.armed) {
            this.onTimeout.run();
        }
    }
}

