/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.threads;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Async {
    public static void sleep(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startAsyncTask(String task, Runnable scheduled, int everySeconds) {
        Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static void startAsyncTask(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
        scheduledExecutorService.scheduleAtFixedRate(() -> scheduled.accept(scheduledExecutorService), 0L, everySeconds, TimeUnit.SECONDS);
    }

    public static Runnable thread(int sleepMilis, Runnable doAfter) {
        return Async.thread(() -> {
            Async.sleep(sleepMilis);
            if (doAfter != null) {
                doAfter.run();
            }
        });
    }

    public static Runnable thread(String name, Runnable doAsync) {
        return new Thread(doAsync, name)::start;
    }

    private static Runnable thread(Runnable doAsync) {
        return new Thread(doAsync)::start;
    }
}

