/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.utils.strings;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class StringUtils {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s+");

    private static String advSplArgUnb(String s) {
        return s.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public static String[] advancedSplitArgs(String args, int expectedArgs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean inAString = false;
        StringBuilder currentBlock = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            if (args.charAt(i) == '\"' && (i == 0 || args.charAt(i - 1) != '\\' || args.charAt(i - 2) == '\\')) {
                boolean bl = inAString = !inAString;
            }
            if (inAString) {
                currentBlock.append(args.charAt(i));
                continue;
            }
            if (Character.isSpaceChar(args.charAt(i))) {
                if (currentBlock.length() == 0) continue;
                if (currentBlock.charAt(0) == '\"' && currentBlock.charAt(currentBlock.length() - 1) == '\"') {
                    currentBlock.deleteCharAt(0);
                    currentBlock.deleteCharAt(currentBlock.length() - 1);
                }
                result.add(StringUtils.advSplArgUnb(currentBlock.toString()));
                currentBlock = new StringBuilder();
                continue;
            }
            currentBlock.append(args.charAt(i));
        }
        if (currentBlock.length() != 0) {
            if (currentBlock.charAt(0) == '\"' && currentBlock.charAt(currentBlock.length() - 1) == '\"') {
                currentBlock.deleteCharAt(0);
                currentBlock.deleteCharAt(currentBlock.length() - 1);
            }
            result.add(StringUtils.advSplArgUnb(currentBlock.toString()));
        }
        String[] raw = result.toArray(new String[result.size()]);
        if (expectedArgs < 1) {
            return raw;
        }
        return StringUtils.normalizeArray(raw, expectedArgs);
    }

    public static String[] efficientSplitArgs(String args, int expectedArgs) {
        char[] array;
        ArrayList<String> result = new ArrayList<String>();
        boolean inAString = false;
        boolean escaping = false;
        StringBuilder currentBlock = new StringBuilder();
        for (char c : array = args.toCharArray()) {
            if (escaping) {
                escaping = false;
                currentBlock.append(StringUtils.escape(c));
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            if (c == '\"') {
                inAString = !inAString;
                continue;
            }
            if (inAString) {
                currentBlock.append(c);
                continue;
            }
            if (Character.isSpaceChar(c)) {
                String block = currentBlock.toString();
                currentBlock = new StringBuilder();
                if (block.isEmpty()) continue;
                result.add(currentBlock.toString());
                currentBlock = new StringBuilder();
                continue;
            }
            currentBlock.append(c);
        }
        String[] raw = result.toArray(new String[result.size()]);
        if (expectedArgs < 1) {
            return raw;
        }
        return StringUtils.normalizeArray(raw, expectedArgs);
    }

    private static char escape(char c) {
        if (c == 'n') {
            return '\n';
        }
        if (c == 'r') {
            return '\r';
        }
        if (c == 't') {
            return '\t';
        }
        return c;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String limit(String value, int length) {
        StringBuilder buf = new StringBuilder(value);
        if (buf.length() > length) {
            buf.setLength(length - 3);
            buf.append("...");
        }
        return buf.toString();
    }

    public static void main(String[] argv) throws Exception {
        long start = System.currentTimeMillis();
        for (int ii = 0; ii < 1000000; ++ii) {
            StringUtils.advancedSplitArgs("a b c d e f g h i j k l m n o p q r s t u v w x y z", 10);
            StringUtils.efficientSplitArgs("a b c d e f g h i j k l m n o p q r s t u v w x y z", 0);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed time = " + elapsed + "ms - " + (double)elapsed * 1000.0 / 1000000.0 + " microseconds per execution");
    }

    public static String[] normalizeArray(String[] raw, int expectedSize) {
        Object[] normalized = new String[expectedSize];
        Arrays.fill(normalized, "");
        for (int i = 0; i < normalized.length; ++i) {
            if (i >= raw.length || raw[i] == null || raw[i].isEmpty()) continue;
            normalized[i] = raw[i];
        }
        return normalized;
    }

    public static String notNullOrDefault(String str, String defaultStr) {
        if (str == null || str.trim().isEmpty()) {
            return defaultStr;
        }
        return str;
    }

    public static Map<String, String> parse(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-' || args[i].charAt(0) == '/') {
                args[i] = args[i].substring(1);
                if (i + 1 >= args.length || args[i + 1].charAt(0) == '-' || args[i + 1].charAt(0) == '/') {
                    options.put(args[i], "null");
                    continue;
                }
                options.put(args[i], args[i + 1]);
                ++i;
                continue;
            }
            options.put(null, args[i]);
        }
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String removeLines(String str, int startline, int numlines) {
        try (BufferedReader br = new BufferedReader(new StringReader(str));){
            String line;
            StringBuilder builder = new StringBuilder("");
            int linenumber = 0;
            --numlines;
            while ((line = br.readLine()) != null) {
                if (linenumber < startline || linenumber >= startline + numlines) {
                    builder.append(line).append("\n");
                }
                ++linenumber;
            }
            String string = builder.toString();
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] splitArgs(String args, int expectedArgs) {
        String[] raw = SPLIT_PATTERN.split(args, expectedArgs);
        if (expectedArgs < 1) {
            return raw;
        }
        return StringUtils.normalizeArray(raw, expectedArgs);
    }
}

