package br.com.brjdevs.java.utils.threads;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Async {
	public static void sleep(int milis) {
		try {
			Thread.sleep(milis);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Start an Async single thread task every x seconds. Replacement for Timer.
	 *
	 * @param task         The name of the task to run
	 * @param scheduled    The runnable.
	 * @param everySeconds the amount of seconds the task will take to loop.
	 */
	public static void startAsyncTask(String task, Runnable scheduled, int everySeconds) {
		Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task)).scheduleAtFixedRate(scheduled, 0, everySeconds, TimeUnit.SECONDS);
	}

	public static void startAsyncTask(String task, Consumer<ScheduledExecutorService> scheduled, int everySeconds) {
		ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, task));
		scheduledExecutorService.scheduleAtFixedRate(() -> scheduled.accept(scheduledExecutorService), 0, everySeconds, TimeUnit.SECONDS);
	}

	public static Runnable thread(final int sleepMilis, final Runnable doAfter) {
		return thread(() -> {
			sleep(sleepMilis);
			if (doAfter != null) doAfter.run();
		});
	}

	public static Runnable thread(final String name, final Runnable doAsync) {
		return new Thread(doAsync, name)::start;
	}

	private static Runnable thread(final Runnable doAsync) {
		return new Thread(doAsync)::start;
	}
}