/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.utils.trove.threads;

import gnu.trove.TCollections;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ScheduledTaskProcessor {
    private final Set<Runnable> expirables = Collections.newSetFromMap(new ConcurrentHashMap());
    private final TLongObjectMap<Set<Runnable>> expirations = TCollections.synchronizedMap((TLongObjectMap)new TLongObjectHashMap());
    private final Consumer<Runnable> onExpired;
    private boolean updated = false;

    public ScheduledTaskProcessor(Consumer<Runnable> onExpired, String name) {
        this.onExpired = onExpired;
        Thread thread = new Thread(this::threadcode, name);
        thread.setDaemon(true);
        thread.start();
    }

    public ScheduledTaskProcessor(String name) {
        this(r -> new Thread((Runnable)r, "Scheduled Task Thread").start(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(long milis, Runnable task) {
        Objects.requireNonNull(task);
        Object object = this.expirations;
        synchronized (object) {
            if (this.expirables.contains(task)) {
                this.expirations.valueCollection().forEach(list -> list.remove(task));
                this.expirables.remove(task);
            }
            if (!this.expirations.containsKey(milis)) {
                this.expirations.put(milis, new LinkedHashSet());
            }
            ((Set)this.expirations.get(milis)).add(task);
            this.expirables.add(task);
        }
        this.updated = true;
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public void addTaskRelative(long millisToAwait, Runnable task) {
        this.addTask(System.currentTimeMillis() + millisToAwait, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable task) {
        Objects.requireNonNull(task);
        Object object = this.expirations;
        synchronized (object) {
            if (this.expirables.contains(task)) {
                this.expirations.valueCollection().forEach(list -> list.remove(task));
                this.expirables.remove(task);
            }
        }
        this.updated = true;
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadcode() {
        while (true) {
            if (this.expirations.isEmpty()) {
                try {
                    ScheduledTaskProcessor scheduledTaskProcessor = this;
                    synchronized (scheduledTaskProcessor) {
                        this.wait();
                        this.updated = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long[] keys = this.expirations.keys();
            long firstEntry = keys[0];
            for (int i = 1; i < keys.length; ++i) {
                if (keys[i] >= firstEntry) continue;
                firstEntry = keys[i];
            }
            long timeout = firstEntry - System.currentTimeMillis();
            if (timeout > 0L) {
                ScheduledTaskProcessor scheduledTaskProcessor = this;
                synchronized (scheduledTaskProcessor) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.updated) {
                Set first = (Set)this.expirations.remove(firstEntry);
                first.remove(null);
                first.forEach(this.onExpired);
                continue;
            }
            this.updated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalLong timeLeft(Runnable task) {
        TLongObjectMap<Set<Runnable>> tLongObjectMap = this.expirations;
        synchronized (tLongObjectMap) {
            OptionalLong first = Arrays.stream(this.expirations.keys()).filter(value -> ((Set)this.expirations.get(value)).contains(task)).findFirst();
            return !first.isPresent() ? first : OptionalLong.of(first.getAsLong() - System.currentTimeMillis());
        }
    }
}

