/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.snowflakes.snow64;

import java.util.Base64;

public class Snow64Converter {
    public static String toSnow64(long snowflake) {
        return Base64.getEncoder().encodeToString(Snow64Converter.toByteArray(snowflake)).replace('/', '-').replace('=', ' ').trim();
    }

    public static long toSnowflake(String snow64) {
        return Snow64Converter.fromByteArray(Base64.getDecoder().decode(snow64.replace('-', '/')));
    }

    private static long fromByteArray(byte[] bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("array too small: " + bytes.length + " < " + 8);
        }
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    private static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }
}

