/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.snowflakes.entities.impl;

import br.com.brjdevs.java.snowflakes.entities.Config;
import br.com.brjdevs.java.snowflakes.entities.Datacenter;
import br.com.brjdevs.java.snowflakes.entities.Worker;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ConfigImpl
implements Config {
    private final Map<Long, DatacenterImpl> cachedDatacenters = new HashMap<Long, DatacenterImpl>();
    private final long datacenterIdBits;
    private final long datacenterIdShift;
    private final long epoch;
    private final long maxDatacenterId;
    private final long maxWorkerId;
    private final long sequenceBits;
    private final long sequenceMask;
    private final long timestampLeftShift;
    private final long workerIdBits;
    private final long workerIdShift;

    private static OffsetDateTime convert(long millis) {
        Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmt.setTimeInMillis(millis);
        return OffsetDateTime.ofInstant(gmt.toInstant(), gmt.getTimeZone().toZoneId());
    }

    public ConfigImpl(long epoch, long datacenterIdBits, long workerIdBits, long sequenceBits) {
        if (epoch < 0L) {
            throw new IllegalArgumentException("epoch must be positive");
        }
        if (epoch > this.timeGen()) {
            throw new IllegalArgumentException("epoch is on the future");
        }
        if (datacenterIdBits < 0L) {
            throw new IllegalArgumentException("datacenterIdBits must be positive");
        }
        if (workerIdBits < 0L) {
            throw new IllegalArgumentException("workerIdBits must be positive");
        }
        if (sequenceBits < 0L) {
            throw new IllegalArgumentException("sequenceBits must be positive");
        }
        if (datacenterIdBits + workerIdBits + sequenceBits >= 64L) {
            throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under 64 bits.");
        }
        this.datacenterIdBits = datacenterIdBits;
        this.sequenceBits = sequenceBits;
        this.epoch = epoch;
        this.workerIdBits = workerIdBits;
        this.datacenterIdShift = sequenceBits + workerIdBits;
        this.timestampLeftShift = this.datacenterIdShift + datacenterIdBits;
        this.workerIdShift = this.sequenceBits;
        this.sequenceMask = -1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxDatacenterId = -1L << (int)this.datacenterIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxWorkerId = -1L << (int)this.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public OffsetDateTime creationTime(long snowflake) {
        return ConfigImpl.convert(this.creationTimeMillis(snowflake));
    }

    @Override
    public long creationTimeMillis(long snowflake) {
        return (snowflake >> (int)this.timestampLeftShift) + this.epoch;
    }

    @Override
    public DatacenterImpl datacenter(long datacenterId) {
        return this.cachedDatacenters.computeIfAbsent(datacenterId, x$0 -> new DatacenterImpl((long)x$0));
    }

    @Override
    public long datacenterBits() {
        return this.datacenterIdBits;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    public OffsetDateTime expirationDate() {
        return ConfigImpl.convert(this.expirationDateMillis());
    }

    @Override
    public long expirationDateMillis() {
        return this.epoch + (2L << (int)(64L - this.timestampLeftShift));
    }

    @Override
    public long sequenceBits() {
        return this.sequenceBits;
    }

    @Override
    public long timeRemaining() {
        return this.expirationDateMillis() - System.currentTimeMillis();
    }

    @Override
    public long timestampBits() {
        return 64L - this.timestampLeftShift;
    }

    @Override
    public boolean valid() {
        return this.timeRemaining() >= 0L;
    }

    @Override
    public DatacenterImpl.WorkerImpl worker(long datacenterId, long workerId) {
        return this.datacenter(datacenterId).worker(workerId);
    }

    @Override
    public long workerBits() {
        return this.workerIdBits;
    }

    public String toString() {
        return String.format("Config[epoch=%d, timestampBits=%d, datacenterIdBits=%d,  workerIdBits=%d, sequenceBits=%d, valid=%s]", this.epoch, 64L - this.timestampLeftShift, this.datacenterIdBits, this.workerIdBits, this.sequenceBits, this.valid());
    }

    private void checkValid() {
        if (this.valid()) {
            throw new IllegalStateException("the config already expired. can't generate new Snowflakes.");
        }
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public class DatacenterImpl
    implements Datacenter {
        private final Map<Long, WorkerImpl> cachedWorkers = new HashMap<Long, WorkerImpl>();
        private final long datacenterId;

        private DatacenterImpl(long datacenterId) {
            if (datacenterId > ConfigImpl.this.maxDatacenterId || datacenterId < 0L) {
                throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", ConfigImpl.this.maxDatacenterId));
            }
            this.datacenterId = datacenterId;
        }

        @Override
        public long id() {
            return this.datacenterId;
        }

        @Override
        public Config setup() {
            return ConfigImpl.this;
        }

        @Override
        public WorkerImpl worker(long workerId) {
            return this.cachedWorkers.computeIfAbsent(workerId, x$0 -> new WorkerImpl((long)x$0));
        }

        public class WorkerImpl
        implements Worker {
            private final long workerId;
            private long lastTimestamp = -1L;
            private long sequence = 0L;

            public WorkerImpl(long workerId) {
                if (workerId > ConfigImpl.this.maxWorkerId || workerId < 0L) {
                    throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", ConfigImpl.this.maxWorkerId));
                }
                this.workerId = workerId;
            }

            @Override
            public Datacenter datacenter() {
                return DatacenterImpl.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long generate() {
                long timestamp = ConfigImpl.this.timeGen();
                if (timestamp < this.lastTimestamp) {
                    throw new IllegalStateException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
                }
                WorkerImpl workerImpl = this;
                synchronized (workerImpl) {
                    if (this.lastTimestamp == timestamp) {
                        this.sequence = this.sequence + 1L & ConfigImpl.this.sequenceMask;
                        if (this.sequence == 0L) {
                            timestamp = this.tilNextMillis(this.lastTimestamp);
                        }
                    } else {
                        this.sequence = 0L;
                    }
                    this.lastTimestamp = timestamp;
                    return timestamp - ConfigImpl.this.epoch << (int)ConfigImpl.this.timestampLeftShift | DatacenterImpl.this.datacenterId << (int)ConfigImpl.this.datacenterIdShift | this.workerId << (int)ConfigImpl.this.workerIdShift | this.sequence;
                }
            }

            @Override
            public long id() {
                return this.workerId;
            }

            @Override
            public Config setup() {
                return ConfigImpl.this;
            }

            public long getDatacenterId() {
                return DatacenterImpl.this.datacenterId;
            }

            public long getWorkerId() {
                return this.workerId;
            }

            private long tilNextMillis(long lastTimestamp) {
                long timestamp = ConfigImpl.this.timeGen();
                while (timestamp <= lastTimestamp) {
                    timestamp = ConfigImpl.this.timeGen();
                }
                return timestamp;
            }
        }
    }
}

